/************************************************************************
 * NAME:	genrevmap.c
 *
 * DESCR:	Given a 5/6-bit map, generate the reverse map C-structure.
 *
 * NOTES:	The map is "included" below.
 ************************************************************************/

#include <stdio.h>
#include "gcrmap.h"

main(int argc, char *argv[])
{
    unsigned char outputmap[256];
    int		i;

    for( i=0; i < 256; i++ ) {
	outputmap[i] = 0xff;	/* this is the "BAD" value	*/
    }

    if (argc != 2) {
	usage(argv[0]);
    }

    switch(atoi(argv[1])) {
    case 6:
	for (i=0; i < gcr6x2map_size; i++) {
	    outputmap[gcr6x2map[i]] = i;
	}
	break;

    case 5:
	for (i=0; i < gcr5x3map_size; i++) {
	    outputmap[gcr5x3map[i]] = i;
	}
	break;

    default:
	usage(argv[0]);
    }

    printf("\t");
    for (i=0; i < sizeof(outputmap); i++) {
	if (i!=0 && i%8==0) {
	    printf(",\n\t");
	} else if ( i!= 0) {
	    printf(", ");
	}
	printf("0x%02x",outputmap[i]);
    }
    printf("\n");
    exit(0);
}

usage(char *prog)
{
	fprintf(stderr,"%s:  USAGE:  %s 5|6\n",prog,prog);
	exit(2);
}
